import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.*;

public class MyToggleButton extends JToggleButton {

	static final ImageIcon normal = new ImageIcon("Icons"+java.io.File.separator+"button.png");
	static final ImageIcon pressed = new ImageIcon("Icons"+java.io.File.separator+"button-down.png");
	static final ImageIcon disabled = new ImageIcon("Icons"+java.io.File.separator+"button-disabled.png");

	public MyToggleButton() {
		super();
	}
	
	public MyToggleButton(Icon icon) {
		super(icon);
	}

	public MyToggleButton(Icon icon, boolean selected) {
		super(icon,selected);
	}

	/*
	public MyToggleButton(String text) {
		super(text);
	}

	public MyToggleButton(String text, boolean selected) {
		super(text,selected);
	}

	public MyToggleButton(String text, Icon icon) {
		super(text,icon);
	}

	public MyToggleButton(String text, Icon icon, boolean selected) {
		super(text,icon,selected);
	}
	*/
    protected void paintComponent(Graphics g) {
		Icon icon = normal;
		if (!isEnabled()) icon = disabled;
        else if (isSelected()) icon = pressed;
		g.drawImage(((ImageIcon)icon).getImage(),2,3,getWidth()-2,getHeight()-3,0,0,icon.getIconWidth(),icon.getIconHeight(),null);
		if (!isEnabled()) icon = getDisabledIcon();
		else icon = getIcon();
		icon.paintIcon(this,g,getWidth()/2-icon.getIconWidth()/2,getHeight()/2-icon.getIconHeight()/2);
    }
}
